ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_OrderDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_DispatchDate]
Truncate Table [OPS_DWS].[dbo].[dimDate]
GO

INSERT INTO [OPS_DWS].[dbo].[dimDate]
           ([DateKey]
           ,[FullDate]
           ,[Quarter]
           ,[QuarterName]
           ,[Year]
           ,[DayNumber]
           ,[WeekNumber]
           ,[Month]
           ,[MonthName]
           ,[MonthShortName]
           ,[DayofWeek]
           ,[DayofWeekName]
           ,[DayofWeekShortName])
     VALUES
           (-1
           ,NULL
           ,-1
           ,'Unknown'
           ,-1
           ,-1
           ,-1
           ,-1
           ,'Unknown'
           ,'Unknown'
           ,-1
           ,'Unknown'
           ,'Unknown')
GO

DECLARE @StartDate DATE = '1985-01-01'	--*\label{comment1}
DECLARE	@EndDate DATE = '2014-08-31'    --*\label{comment2}
;

WITH Stage AS
(
SELECT CAST(@StartDate AS DATETIME) MyDate
UNION ALL
SELECT MyDate + 1
FROM Stage
WHERE MyDate + 1 <= @EndDate
)
INSERT INTO [OPS_DWS].[dbo].[dimDate] 
SELECT CAST(CONVERT(CHAR(8),CAST(MyDate AS DATETIME),112) AS INT) AS DateKey
,MyDate
,Case 
	When MONTH(MyDate) Between 1 and 3 Then 1 
	When MONTH(MyDate) Between 4 and 6 Then 2 
	When MONTH(MyDate) Between 7 and 9 Then 3 
	When MONTH(MyDate) Between 10 and 12 Then 4 
End As [Quarter] 
,Case 
	When MONTH(MyDate) Between 1 and 3 Then 'Quarter 1' 
	When MONTH(MyDate) Between 4 and 6 Then 'Quarter 2' 
	When MONTH(MyDate) Between 7 and 9 Then 'Quarter 3' 
	When MONTH(MyDate) Between 10 and 12 Then 'Quarter 4' 
End As QuarterName 	
, YEAR(MyDate) AS [Year]
, DATEPART(dy, MyDate) AS DayNumber
, DATEPART(wk, MyDate) AS WeekNumber
, MONTH(MyDate) AS [Month]
, DATENAME(mm, MyDate) AS [MonthName]
, CONVERT(VARCHAR(3), DATENAME(MONTH, MyDate), 100) AS MonthShortName
, DAY(MyDate) AS DayOfWeek
, DATENAME(dw, MyDate) AS DayOfWeekName
, CONVERT(VARCHAR(3), DATENAME(dw, MyDate)) AS DayOfWeekShortName
, GETDATE()
FROM Stage
OPTION (MAXRECURSION 0)
GO

ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_OrderDate] FOREIGN KEY([OrderDateKey])
REFERENCES [OPS_DWS].[dbo].[dimDate] ([DateKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_OrderDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_DispatchDate] FOREIGN KEY([DispatchDateKey])
REFERENCES [OPS_DWS].[dbo].[dimDate] ([DateKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_DispatchDate]
GO