USE [OPS_STG]
GO

IF OBJECT_ID('[dbo].[tmpDailyTxn]') IS NOT NULL
	BEGIN
		DROP TABLE [dbo].[tmpDailyTxn]
	END
Go

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET DATEFORMAT dmy;
GO

CREATE TABLE [dbo].[tmpDailyTxn](
	[OrderID] [int] NOT NULL,
	[CustomerID] [nchar](5) NOT NULL,
	[ProductID] [int] NOT NULL,
	[EmployeeID] [int] NULL,
	[OrderDate] [datetime] NULL,
	[DispatchDate] [datetime] NULL,
	[PriceMatch] [nvarchar](50) NULL,
	[UnitPrice] [money] NOT NULL,
	[Quantity] [smallint] NOT NULL,
	[Discount] [real] NOT NULL,
	[GiftWrap] [nchar](5) NULL,	
) ON [PRIMARY]
GO

BULK INSERT dbo.tmpDailyTxn FROM 'C:/Workspace/TestData/SalesTransactions.csv'  WITH (FIRSTROW = 2, FIELDTERMINATOR = ',', ROWTERMINATOR = '\n')
GO