USE [master]
GO

CREATE DATABASE [OPS] ON  PRIMARY 
	( NAME = N'OPS', FILENAME = N'C:\AutoDB\OPS.mdf' , SIZE = 5504KB , MAXSIZE = UNLIMITED, FILEGROWTH = 10%)
	 LOG ON 
	( NAME = N'OPS_log', FILENAME = N'C:\AutoDB\OPS.ldf' , SIZE = 3456KB , MAXSIZE = UNLIMITED, FILEGROWTH = 10%)
	GO

ALTER DATABASE [OPS] SET COMPATIBILITY_LEVEL = 90

IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
	EXEC [OPS].[dbo].[sp_fulltext_database] @action = 'disable'
end

ALTER DATABASE [OPS] SET ANSI_NULL_DEFAULT OFF 
ALTER DATABASE [OPS] SET ANSI_NULLS OFF 
ALTER DATABASE [OPS] SET ANSI_PADDING OFF 
ALTER DATABASE [OPS] SET ANSI_WARNINGS OFF 
ALTER DATABASE [OPS] SET ARITHABORT OFF 
ALTER DATABASE [OPS] SET AUTO_CLOSE ON 
ALTER DATABASE [OPS] SET AUTO_CREATE_STATISTICS ON 
ALTER DATABASE [OPS] SET AUTO_SHRINK OFF 
ALTER DATABASE [OPS] SET AUTO_UPDATE_STATISTICS ON 
ALTER DATABASE [OPS] SET CURSOR_CLOSE_ON_COMMIT OFF 
ALTER DATABASE [OPS] SET CURSOR_DEFAULT  GLOBAL 
ALTER DATABASE [OPS] SET CONCAT_NULL_YIELDS_NULL OFF 
ALTER DATABASE [OPS] SET NUMERIC_ROUNDABORT OFF 
ALTER DATABASE [OPS] SET QUOTED_IDENTIFIER OFF 
ALTER DATABASE [OPS] SET RECURSIVE_TRIGGERS OFF 
ALTER DATABASE [OPS] SET  ENABLE_BROKER 
ALTER DATABASE [OPS] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
ALTER DATABASE [OPS] SET DATE_CORRELATION_OPTIMIZATION OFF 
ALTER DATABASE [OPS] SET TRUSTWORTHY OFF 
ALTER DATABASE [OPS] SET ALLOW_SNAPSHOT_ISOLATION OFF 
ALTER DATABASE [OPS] SET PARAMETERIZATION SIMPLE 
ALTER DATABASE [OPS] SET READ_COMMITTED_SNAPSHOT OFF 
ALTER DATABASE [OPS] SET HONOR_BROKER_PRIORITY OFF 
ALTER DATABASE [OPS] SET  READ_WRITE 
ALTER DATABASE [OPS] SET RECOVERY SIMPLE 
ALTER DATABASE [OPS] SET  MULTI_USER 
ALTER DATABASE [OPS] SET PAGE_VERIFY TORN_PAGE_DETECTION  
ALTER DATABASE [OPS] SET DB_CHAINING OFF 
GO


