SET DATEFORMAT dmy;
GO

Truncate Table [OPS_STG].dbo.tmpDailyTxn
GO

BULK INSERT [OPS_STG].dbo.tmpDailyTxn FROM 'C:/Workspace/TestData/XLS.csv'  WITH (FIRSTROW = 2, FIELDTERMINATOR = ',', ROWTERMINATOR = '\n')
GO

ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_Customer]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_Product]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_Employee]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_OrderDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_DispatchDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_GiftWrapYesNoKey]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_PriceMatch]
GO

delete FROM [OPS_DWS].[dbo].[factSales]
where [DataSource] = 'SalesTransactions.xls'
GO  
INSERT INTO [OPS_DWS].[dbo].[factSales]
SELECT 'SalesTransactions.xls'
      ,o.[OrderID]
      ,ISNULL(c.CustomerKey, -1) CustomerKey
      ,ISNULL(p.ProductKey, -1)  ProductKey
      ,ISNULL(e.EmployeeKey, -1) EmployeeKey
      ,ISNULL(dtOrd.DateKey, -1) OrderDateKey
      ,ISNULL(dtShp.DateKey, -1) DispatchDateKey
      ,ISNULL(pm.PriceMatchKey, -1) PriceMatchKey
      ,o.UnitPrice 
      ,o.Quantity 
      ,o.Discount 
      ,ISNULL(yn.YesNoKey, -1) GiftWrapYesNoKey
      ,GETDATE()
FROM [OPS_STG].[dbo].[tmpDailyTxn] o
LEFT JOIN [OPS_DWS].[dbo].[dimCustomer] c on c.CustomerID = o.CustomerID 
LEFT JOIN [OPS_DWS].[dbo].[dimProduct] p on p.ProductID = o.ProductID   
LEFT JOIN [OPS_DWS].[dbo].[dimEmployee] e on e.EmployeeID = o.EmployeeID 
LEFT JOIN [OPS_DWS].[dbo].[dimDate] dtOrd on dtOrd.FullDate = o.OrderDate 
LEFT JOIN [OPS_DWS].[dbo].[dimDate] dtShp on dtShp.FullDate = o.DispatchDate
LEFT JOIN [OPS_DWS].[dbo].[dimYesNo] yn on yn.YesNoDescription = o.GiftWrap 
LEFT JOIN [OPS_DWS].[dbo].[dimPriceMatch] pm on pm.[PriceMatchDescription] = o.PriceMatch 
GO

ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_Customer] FOREIGN KEY([CustomerKey])
REFERENCES [OPS_DWS].[dbo].[dimCustomer] ([CustomerKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_Customer]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_Product] FOREIGN KEY([ProductKey])
REFERENCES [OPS_DWS].[dbo].[dimProduct] ([ProductKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_Product]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_Employee] FOREIGN KEY([EmployeeKey])
REFERENCES [OPS_DWS].[dbo].[dimEmployee] ([EmployeeKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_Employee]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_OrderDate] FOREIGN KEY([OrderDateKey])
REFERENCES [OPS_DWS].[dbo].[dimDate] ([DateKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_OrderDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_DispatchDate] FOREIGN KEY([DispatchDateKey])
REFERENCES [OPS_DWS].[dbo].[dimDate] ([DateKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_DispatchDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_GiftWrapYesNoKey] FOREIGN KEY([GiftWrapYesNoKey])
REFERENCES [OPS_DWS].[dbo].[dimYesNo] ([YesNoKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_GiftWrapYesNoKey]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_PriceMatch] FOREIGN KEY([PriceMatchKey])
REFERENCES [OPS_DWS].[dbo].[dimPriceMatch] ([PriceMatchKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_PriceMatch]
GO