ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_Customer]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_Product]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_Employee]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_OrderDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_DispatchDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_GiftWrapYesNoKey]
ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_PriceMatch]
truncate table [OPS_DWS].[dbo].[factSales] 
GO

INSERT INTO [OPS_DWS].[dbo].[factSales]
SELECT 'Table Order'
      ,o.[OrderID]
      ,ISNULL(c.CustomerKey, -1) CustomerKey
      ,ISNULL(p.ProductKey, -1)  ProductKey
      ,ISNULL(e.EmployeeKey, -1) EmployeeKey
      ,ISNULL(dtOrd.DateKey, -1) OrderDateKey
      ,ISNULL(dtShp.DateKey, -1) DispatchDateKey
      ,ISNULL(pm.PriceMatchKey, -1) PriceMatchKey
      ,od.UnitPrice 
      ,od.Quantity 
      ,od.Discount 
      ,ISNULL(yn.YesNoKey, -1) GiftWrapYesNoKey
      ,GETDATE()
FROM [OPS_STG].[dbo].[Orders] o
INNER JOIN [OPS_STG].[dbo].[OrderDetails] od on od.[OrderID] = o.[OrderID]
LEFT JOIN [OPS_DWS].[dbo].[dimCustomer] c on c.CustomerID = o.CustomerID 
LEFT JOIN [OPS_DWS].[dbo].[dimProduct] p on p.ProductID = od.ProductID   
LEFT JOIN [OPS_DWS].[dbo].[dimEmployee] e on e.EmployeeID = o.EmployeeID 
LEFT JOIN [OPS_DWS].[dbo].[dimDate] dtOrd on dtOrd.FullDate = o.OrderDate 
LEFT JOIN [OPS_DWS].[dbo].[dimDate] dtShp on dtShp.FullDate = o.DispatchDate
LEFT JOIN [OPS_DWS].[dbo].[dimYesNo] yn on yn.YesNoDescription = od.GiftWrap 
LEFT JOIN [OPS_DWS].[dbo].[dimPriceMatch] pm on pm.[PriceMatchDescription] = od.PriceMatch 
GO

ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_Customer] FOREIGN KEY([CustomerKey])
REFERENCES [OPS_DWS].[dbo].[dimCustomer] ([CustomerKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_Customer]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_Product] FOREIGN KEY([ProductKey])
REFERENCES [OPS_DWS].[dbo].[dimProduct] ([ProductKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_Product]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_Employee] FOREIGN KEY([EmployeeKey])
REFERENCES [OPS_DWS].[dbo].[dimEmployee] ([EmployeeKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_Employee]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_OrderDate] FOREIGN KEY([OrderDateKey])
REFERENCES [OPS_DWS].[dbo].[dimDate] ([DateKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_OrderDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_DispatchDate] FOREIGN KEY([DispatchDateKey])
REFERENCES [OPS_DWS].[dbo].[dimDate] ([DateKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_DispatchDate]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_GiftWrapYesNoKey] FOREIGN KEY([GiftWrapYesNoKey])
REFERENCES [OPS_DWS].[dbo].[dimYesNo] ([YesNoKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_GiftWrapYesNoKey]
ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_PriceMatch] FOREIGN KEY([PriceMatchKey])
REFERENCES [OPS_DWS].[dbo].[dimPriceMatch] ([PriceMatchKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_PriceMatch]
GO