USE [master]
GO

CREATE DATABASE [OPS_DWS] ON  PRIMARY 
( NAME = N'OPS_DWS', FILENAME = N'C:\AutoDB\OPS_DWS.mdf' , SIZE = 5504KB , MAXSIZE = UNLIMITED, FILEGROWTH = 10%)
 LOG ON 
( NAME = N'OPS_DWS_log', FILENAME = N'C:\AutoDB\OPS_DWS.ldf' , SIZE = 3456KB , MAXSIZE = UNLIMITED, FILEGROWTH = 10%)
GO

ALTER DATABASE [OPS_DWS] SET COMPATIBILITY_LEVEL = 90

IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
	EXEC [OPS_DWS].[dbo].[sp_fulltext_database] @action = 'disable'
end

ALTER DATABASE [OPS_DWS] SET ANSI_NULL_DEFAULT OFF 
ALTER DATABASE [OPS_DWS] SET ANSI_NULLS OFF 
ALTER DATABASE [OPS_DWS] SET ANSI_PADDING OFF 
ALTER DATABASE [OPS_DWS] SET ANSI_WARNINGS OFF 
ALTER DATABASE [OPS_DWS] SET ARITHABORT OFF 
ALTER DATABASE [OPS_DWS] SET AUTO_CLOSE ON 
ALTER DATABASE [OPS_DWS] SET AUTO_CREATE_STATISTICS ON 
ALTER DATABASE [OPS_DWS] SET AUTO_SHRINK OFF 
ALTER DATABASE [OPS_DWS] SET AUTO_UPDATE_STATISTICS ON 
ALTER DATABASE [OPS_DWS] SET CURSOR_CLOSE_ON_COMMIT OFF 
ALTER DATABASE [OPS_DWS] SET CURSOR_DEFAULT  GLOBAL 
ALTER DATABASE [OPS_DWS] SET CONCAT_NULL_YIELDS_NULL OFF 
ALTER DATABASE [OPS_DWS] SET NUMERIC_ROUNDABORT OFF 
ALTER DATABASE [OPS_DWS] SET QUOTED_IDENTIFIER OFF 
ALTER DATABASE [OPS_DWS] SET RECURSIVE_TRIGGERS OFF 
ALTER DATABASE [OPS_DWS] SET ENABLE_BROKER 
ALTER DATABASE [OPS_DWS] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
ALTER DATABASE [OPS_DWS] SET DATE_CORRELATION_OPTIMIZATION OFF 
ALTER DATABASE [OPS_DWS] SET TRUSTWORTHY OFF 
ALTER DATABASE [OPS_DWS] SET ALLOW_SNAPSHOT_ISOLATION OFF 
ALTER DATABASE [OPS_DWS] SET PARAMETERIZATION SIMPLE 
ALTER DATABASE [OPS_DWS] SET READ_COMMITTED_SNAPSHOT OFF 
ALTER DATABASE [OPS_DWS] SET HONOR_BROKER_PRIORITY OFF 
ALTER DATABASE [OPS_DWS] SET READ_WRITE 
ALTER DATABASE [OPS_DWS] SET RECOVERY SIMPLE 
ALTER DATABASE [OPS_DWS] SET MULTI_USER 
ALTER DATABASE [OPS_DWS] SET PAGE_VERIFY TORN_PAGE_DETECTION  
ALTER DATABASE [OPS_DWS] SET DB_CHAINING OFF 
GO


