ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_Customer]
Truncate table [OPS_DWS].[dbo].[dimCustomer] 
GO

SET IDENTITY_INSERT [OPS_DWS].[dbo].[dimCustomer] ON

INSERT INTO [OPS_DWS].[dbo].[dimCustomer]
           ([CustomerKey]
           ,[CustomerID]
           ,[LastName]
           ,[FirstName]
           ,[Title]
           ,[DisplayName]
           ,[DateOfBirth]
           ,[Address]
           ,[City]
           ,[County]
           ,[Postcode]
           ,[Country]
           ,[Phone]
           ,[Fax]
           ,[Region])
     VALUES
           (-1
           ,-1
           ,'Unknown'
           ,'Unknown'
           ,'Unknown'
           ,'Unknown'
           ,NULL
           ,'Unknown'
           ,'Unknown'
           ,'Unknown'
           ,'Unknown'
           ,'Unknown'
           ,'Unknown'
           ,'Unknown'
           ,'Unknown')

SET IDENTITY_INSERT [OPS_DWS].[dbo].[dimCustomer] OFF
GO

INSERT INTO [OPS_DWS].[dbo].[dimCustomer] 
SELECT [CustomerID],[LastName],[FirstName],[Title]
      , Rtrim(Ltrim([Title] + ' ' + [FirstName] +  ' ' + [LastName])) AS [DisplayName]
      ,[DateOfBirth],[Address]
      ,[City],[County],[Postcode],[Country],[Phone],[Fax], 
       CASE WHEN UPPER(LEFT([Postcode],2)) Between 'A' and 'G' THEN 'North' 
		  WHEN UPPER(LEFT([Postcode],2)) Between 'H' and 'N' THEN 'South'
		  WHEN UPPER(LEFT([Postcode],2)) Between 'O' and 'R' THEN 'East'
		  WHEN UPPER(LEFT([Postcode],2)) Between 'S' and 'Z' THEN 'West'
		  ELSE 'Unknown' 
	   END AS [Region],
       GETDATE()
FROM [OPS_STG].[dbo].[Customers]
GO

ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_Customer] FOREIGN KEY([CustomerKey])
REFERENCES [OPS_DWS].[dbo].[dimCustomer] ([CustomerKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_Customer]
