ALTER TABLE [OPS_DWS].[dbo].[factSales] DROP CONSTRAINT [FK_factSales_Product]
GO

truncate table [OPS_DWS].[dbo].[dimProduct]
GO

SET IDENTITY_INSERT [OPS_DWS].[dbo].[dimProduct] ON

INSERT INTO [OPS_DWS].[dbo].[dimProduct]
           (ProductKey
           ,[ProductID]
           ,[ProductType]
           ,[ProductName]
           ,[UnitPrice]
           ,[UnitsInStock]
           ,[UnitsOnOrder]
           ,[ReorderLevel]
           ,[Discontinued])
     VALUES
           (-1
           ,-1
           ,'Unknown'
           ,'Unknown'
           ,-1
           ,-1
           ,-1
           ,-1
           ,'Unknown')

SET IDENTITY_INSERT [OPS_DWS].[dbo].[dimProduct] OFF
GO

INSERT INTO [OPS_DWS].[dbo].[dimProduct] 
SELECT [ProductID],
		CASE WHEN [ProductID] <= 50 THEN 'Domenstic' 
			 WHEN [ProductID] Between 50 and 75 THEN 'Commercial' 
			 WHEN [ProductID] > 75 THEN 'Other' 
			 ELSE 'Unknown' 
		END AS [ProductType],
	   [ProductName],[UnitPrice],[UnitsInStock],
       [UnitsOnOrder],[ReorderLevel],
       CASE [Discontinued] 
            WHEN 1 THEN 'Yes' 
			WHEN 0 THEN 'No' 
			ELSE 'Unknown' 
		END AS [Discontinued],
       GETDATE()
FROM [OPS_STG].[dbo].[Products]
GO

ALTER TABLE [OPS_DWS].[dbo].[factSales]  WITH NOCHECK ADD  CONSTRAINT [FK_factSales_Product] FOREIGN KEY([ProductKey])
REFERENCES [OPS_DWS].[dbo].[dimProduct] ([ProductKey])
ALTER TABLE [OPS_DWS].[dbo].[factSales] CHECK CONSTRAINT [FK_factSales_Product]
GO