﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApplication
{
    public partial class frmEmployeeList : Form
    {
        public frmEmployeeList()
        {
            InitializeComponent();
        }

        private void frmEmployeeList_Load(object sender, EventArgs e)
        {
            PopulateEmps();
        }

        public void PopulateEmps()
        {
            lvEmployeeList.HideSelection = false;

            lvEmployeeList.Clear();
            lvEmployeeList.Columns.Add("Employee Id", 75);
            lvEmployeeList.Columns.Add("Title", 50);
            lvEmployeeList.Columns.Add("Name", 120);
            lvEmployeeList.Columns.Add("Gender", 75);
            lvEmployeeList.Columns.Add("Date of Birth", 90);
            lvEmployeeList.Columns.Add("Contract", 74);

            ListViewItem lv = new ListViewItem();
            lv.Text = "10001";
            lv.SubItems.Add("Mrs");
            lv.SubItems.Add("Carla Brown");
            lv.SubItems.Add("Female");
            lv.SubItems.Add("02/05/1965");
            lv.SubItems.Add("Yes");
            lvEmployeeList.Items.Add(lv);

            ListViewItem lv1 = new ListViewItem();
            lv1.Text = "10002";
            lv1.SubItems.Add("Mr");
            lv1.SubItems.Add("James Jones");
            lv1.SubItems.Add("Male");
            lv1.SubItems.Add("03/12/1978");
            lv1.SubItems.Add("Yes");
            lvEmployeeList.Items.Add(lv1);

            ListViewItem lv2 = new ListViewItem();
            lv2.Text = "10003";
            lv2.SubItems.Add("Miss");
            lv2.SubItems.Add("D Mellons");
            lv2.SubItems.Add("Female");
            lv2.SubItems.Add("10/10/1970");
            lv2.SubItems.Add("No");
            lvEmployeeList.Items.Add(lv2);

            ListViewItem lv3 = new ListViewItem();
            lv3.Text = "10004";
            lv3.SubItems.Add("Miss");
            lv3.SubItems.Add("Sarah Smith");
            lv3.SubItems.Add("Female");
            lv3.SubItems.Add("25/12/1982");
            lv3.SubItems.Add("No");
            lvEmployeeList.Items.Add(lv3);

            ListViewItem lv4 = new ListViewItem();
            lv4.Text = "10005";
            lv4.SubItems.Add("Mrs");
            lv4.SubItems.Add("Nicola");
            lv4.SubItems.Add("Female");
            lv4.SubItems.Add("31/12/1978");
            lv4.SubItems.Add("Yes");
            lvEmployeeList.Items.Add(lv4);

            if (lvEmployeeList.Items.Count > 0)
            {
                lvEmployeeList.Items[0].Selected = true;
                lvEmployeeList.Select();
            }

            //lvEmployeeList.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent);
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnView_Click(object sender, EventArgs e)
        {
            if (lvEmployeeList.SelectedItems.Count > 0)
            {
                string emp = lvEmployeeList.SelectedItems[0].Text;
                frmEmployee myEmp = new frmEmployee(Config.VIEW_EMPLIST, emp);
                //myEmp.Parent = this;
                myEmp.StartPosition = FormStartPosition.CenterScreen;
                myEmp.ShowInTaskbar = false;
                myEmp.ShowDialog();
            }
        }

        private void lvEmployeeList_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void lvEmployeeList_DoubleClick(object sender, EventArgs e)
        {
            //MessageBox.Show(lvEmployeeList.SelectedItems[0].SubItems[0].Text);
            btnView.PerformClick();
        }
    }
}
