﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApplication
{
    public delegate void NotifyParentDelegate(string ww);

    public partial class frmMain : Form
    {        
        public frmMain()
        {
            InitializeComponent();
            menuTester.Visible = false;
            menuAdmin.Visible = false;
        }

        private void menuHelpAbout_Click(object sender, EventArgs e)
        {
            frmAbout myAbout = new frmAbout(this);
            myAbout.MdiParent = this;
            myAbout.StartPosition = FormStartPosition.CenterScreen;
            myAbout.Show();
        }

        private void menuFileLogin_Click(object sender, EventArgs e)
        {
            frmLogin myLogin = new frmLogin(this);
            myLogin.NotifyParentEvent += new NotifyParentDelegate(_child_NotifyParentEvent);
            myLogin.MdiParent = this;
            myLogin.StartPosition = FormStartPosition.CenterScreen;
            myLogin.Show();
        }

        private void menuFileExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        void _child_NotifyParentEvent(string w)
        {
            if (w.Equals("Tester"))
                menuTester.Visible = true;
            else if (w.Equals("Admin"))
                menuAdmin.Visible = true;

            menuFileLogout.Enabled = true;
            menuFileLogin.Enabled = false;
        }

        private void menuFileLogout_Click(object sender, EventArgs e)
        {

            menuTester.Visible = false;
            menuAdmin.Visible = false;
            menuFileLogout.Enabled = false;
            menuFileLogin.Enabled = true;
        }

        private void menuTesterAddEmployee_Click(object sender, EventArgs e)
        {
            frmEmployee myEmp = new frmEmployee(Config.ADD_OPERATION);
            myEmp.MdiParent = this;
            myEmp.StartPosition = FormStartPosition.CenterScreen;
            myEmp.Show();
        }

        private void menuTesterViewEmployee_Click(object sender, EventArgs e)
        {
            frmEmployee myEmp = new frmEmployee(Config.VIEW_OPERATION);
            myEmp.MdiParent = this;
            myEmp.StartPosition = FormStartPosition.CenterScreen;
            myEmp.Show();
        }

        private void menuAdminEmployeeList_Click(object sender, EventArgs e)
        {
            frmEmployeeList myEmpList = new frmEmployeeList();
            myEmpList.MdiParent = this;
            myEmpList.StartPosition = FormStartPosition.CenterScreen;
            myEmpList.Show();
        }

        private void menuOther_Click(object sender, EventArgs e)
        {
            frmOther myother = new frmOther();
            myother.MdiParent = this;
            myother.StartPosition = FormStartPosition.CenterScreen;
            myother.Show();
        }
    }
}
