﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace WpfApplication
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    /// 
    public delegate void NotifyParentDelegate(string ww);

    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            this.WindowState = WindowState.Maximized;
            //imgfromfoldercodebehind.Source = new BitmapImage(new Uri(@"\images\login.ico", UriKind.Relative));
            //MessageBox.Show(imgfromfoldercodebehind.Source.ToString());

            //imgfromorigin.Source = new BitmapImage(new Uri(AppDomain.CurrentDomain.BaseDirectory + "\\images\\login.ico", UriKind.Absolute));
            //MessageBox.Show(imgfromorigin.Source.ToString());
        }

        private void mnuLogin_Click(object sender, RoutedEventArgs e)
        {
            LoginWindow lgn = new LoginWindow();
            lgn.NotifyParentEvent += new NotifyParentDelegate(_child_NotifyParentEvent);
            lgn.Owner = this;
            lgn.ShowInTaskbar = false;
            lgn.WindowStartupLocation = WindowStartupLocation.CenterOwner;
            lgn.Show();
        }

        private void mnuLogout_Click(object sender, RoutedEventArgs e)
        {
            menuItemLogout.IsEnabled = false;
            menuItemLogin.IsEnabled = true;
            menuTester.IsEnabled = false;
            menuAdmin.IsEnabled = false;
        }
        private void mnuExit_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        void _child_NotifyParentEvent(string w)
        {
            //MessageBox.Show("Who logged in: " + w);

            menuItemLogout.IsEnabled = true;
            menuItemLogin.IsEnabled = false;

            if (w.Equals("Tester"))
                menuTester.IsEnabled = true;
            else if (w.Equals("Admin"))
                menuAdmin.IsEnabled = true;
        }

        private void mnuEmpList_Click(object sender, RoutedEventArgs e)
        {
            EmpList el = new EmpList();
            //el.NotifyParentEvent += new NotifyParentDelegate(_child_NotifyParentEvent);
            el.Owner = this;
            el.ShowInTaskbar = false;
            el.WindowStartupLocation = WindowStartupLocation.CenterOwner;
            el.Show();
        }
    }
}
